# GNU Make project makefile autogenerated by Premake
ifndef config
  config=debug
endif

ifndef verbose
  SILENT = @
endif

ifndef CC
  CC = gcc
endif

ifndef CXX
  CXX = g++
endif

ifndef AR
  AR = ar
endif

ifeq ($(config),debug)
  OBJDIR     = obj/debug/image_viewer
  TARGETDIR  = .
  TARGET     = $(TARGETDIR)/image_viewer
  DEFINES   += -DDEBUG -DVERBOSE
  INCLUDES  += -I. -IgKit -IgKit/Widgets -Iglew-1.7.0/include
  CPPFLAGS  += -MMD -MP $(DEFINES) $(INCLUDES)
  CFLAGS    += $(CPPFLAGS) $(ARCH) -Wall -g -pipe `sdl-config --cflags` -march=native
  CXXFLAGS  += $(CFLAGS) 
  LDFLAGS   += -Wl,-rpath,glew-1.7.0/lib -Lglew-1.7.0/lib -lGLEW `sdl-config --libs` -Wl,-rpath,. -L. -L.
  LIBS      += -lGL -lSDL_image -lSDL_ttf -lgKitShared
  RESFLAGS  += $(DEFINES) $(INCLUDES) 
  LDDEPS    += libgKitShared.so
  LINKCMD    = $(CXX) -o $(TARGET) $(OBJECTS) $(LDFLAGS) $(RESOURCES) $(ARCH) $(LIBS)
  define PREBUILDCMDS
  endef
  define PRELINKCMDS
  endef
  define POSTBUILDCMDS
  endef
endif

ifeq ($(config),release)
  OBJDIR     = obj/release/image_viewer
  TARGETDIR  = .
  TARGET     = $(TARGETDIR)/image_viewer
  DEFINES   += -DNDEBUG -DVERBOSE
  INCLUDES  += -I. -IgKit -IgKit/Widgets -Iglew-1.7.0/include
  CPPFLAGS  += -MMD -MP $(DEFINES) $(INCLUDES)
  CFLAGS    += $(CPPFLAGS) $(ARCH) -O2 -pipe `sdl-config --cflags` -march=native -march=native -mfpmath=sse -msse3
  CXXFLAGS  += $(CFLAGS) 
  LDFLAGS   += -s -Wl,-rpath,glew-1.7.0/lib -Lglew-1.7.0/lib -lGLEW `sdl-config --libs` -Wl,-rpath,. -L. -L.
  LIBS      += -lGL -lSDL_image -lSDL_ttf -lgKitShared
  RESFLAGS  += $(DEFINES) $(INCLUDES) 
  LDDEPS    += libgKitShared.so
  LINKCMD    = $(CXX) -o $(TARGET) $(OBJECTS) $(LDFLAGS) $(RESOURCES) $(ARCH) $(LIBS)
  define PREBUILDCMDS
  endef
  define PRELINKCMDS
  endef
  define POSTBUILDCMDS
  endef
endif

OBJECTS := \
	$(OBJDIR)/image_viewer.o \

RESOURCES := \

SHELLTYPE := msdos
ifeq (,$(ComSpec)$(COMSPEC))
  SHELLTYPE := posix
endif
ifeq (/bin,$(findstring /bin,$(SHELL)))
  SHELLTYPE := posix
endif

.PHONY: clean prebuild prelink

all: $(TARGETDIR) $(OBJDIR) prebuild prelink $(TARGET)
	@:

$(TARGET): $(GCH) $(OBJECTS) $(LDDEPS) $(RESOURCES)
	@echo Linking image_viewer
	$(SILENT) $(LINKCMD)
	$(POSTBUILDCMDS)

$(TARGETDIR):
	@echo Creating $(TARGETDIR)
ifeq (posix,$(SHELLTYPE))
	$(SILENT) mkdir -p $(TARGETDIR)
else
	$(SILENT) mkdir $(subst /,\\,$(TARGETDIR))
endif

$(OBJDIR):
	@echo Creating $(OBJDIR)
ifeq (posix,$(SHELLTYPE))
	$(SILENT) mkdir -p $(OBJDIR)
else
	$(SILENT) mkdir $(subst /,\\,$(OBJDIR))
endif

clean:
	@echo Cleaning image_viewer
ifeq (posix,$(SHELLTYPE))
	$(SILENT) rm -f  $(TARGET)
	$(SILENT) rm -rf $(OBJDIR)
else
	$(SILENT) if exist $(subst /,\\,$(TARGET)) del $(subst /,\\,$(TARGET))
	$(SILENT) if exist $(subst /,\\,$(OBJDIR)) rmdir /s /q $(subst /,\\,$(OBJDIR))
endif

prebuild:
	$(PREBUILDCMDS)

prelink:
	$(PRELINKCMDS)

ifneq (,$(PCH))
$(GCH): $(PCH)
	@echo $(notdir $<)
	-$(SILENT) cp $< $(OBJDIR)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"
endif

$(OBJDIR)/image_viewer.o: image_viewer.cpp
	@echo $(notdir $<)
	$(SILENT) $(CXX) $(CXXFLAGS) -o "$@" -c "$<"

-include $(OBJECTS:%.o=%.d)
