
#include <cstdio>
#include <cstdlib>
#include <cassert>
#include <time.h>
#include <algorithm>

int main( ) 
{
    srand48(time(NULL));
    
    // choisir un intervalle [a .. b] aleatoirement
    float a= drand48();
    float b= drand48();
    if(b < a)
        // verifier que a est bien la borne min de l'intervalle
        std::swap(a, b);
    assert(a < b);
    
    // choisir aleatoirement c, un point de l'intervalle [a .. b]
    float c= a + (b - a) * drand48();
    assert(c >= a && c <= b);
    printf("a %f b %f c %f\n", a, b, c);
    
    // recherche dichotomique de c dans l'intervalle [a .. b]
    int n= 0;
    float m;
    for(;;)
    {
        m= (a + b) / 2.f;    // point milieu de l'intervalle [a .. b]
        assert(a != m);
        
        if(c < m)
            b= m;       // prochaine recherche sur [a .. m]
        else if(c > m)
            a= m;       // prochaine recherche sur [m .. b]
        else
            break; // m == c, trouve
        
        n++;    // compter le nombre d'iterations necessaire
    }
    
    // afficher le resultat
    printf("a %f b %f c %f, m %f, e= %f, iterations %d\n", a, b, c, m, c - a, n);
    printf("done.\n");
    return 0;
}
