
#include "GL/GLPlatform.h"
#include "Mesh.h"
#include "MeshIO.h"
#include "BufferManager.h"
#include "ShaderManager.h"

#include "App.h"


class TP : public gk::App
{
    gk::GLShaderProgram *m_program;
    gk::GLBuffer *m_positions;
    gk::GLBuffer *m_index;
    int m_index_count;
    int m_position_count;
    
public:
    TP( const int w= 1024, const int h= 768 )
        :
        gk::App(w, h),
        m_program(NULL),
        m_positions(NULL),
        m_index(NULL),
        m_index_count(0),
        m_position_count(0)
    {}
    
    ~TP( ) {}
    
    int init( )         // charger les objets, les vertex buffers, etc.
    {
        m_program= gk::createShaderProgram("core_simple.vsl", "core_simple.fsl");
        if(m_program == NULL || m_program->createGLResource() < 0)
            return -1;
        
        gk::Mesh *mesh= gk::MeshIO::read("bigguy.obj");
        if(mesh == NULL)
            return -1;
        
        m_positions= gk::createBuffer(GL_ARRAY_BUFFER, mesh->positionCount() * sizeof(float [3]), &mesh->positions().front());
        if(m_positions == NULL || m_positions->createGLResource() < 0)
            return -1;
        m_position_count= mesh->positionCount();
        
        m_index= gk::createBuffer(GL_ELEMENT_ARRAY_BUFFER, mesh->indiceCount() * sizeof(int), &mesh->indices().front());
        if(m_index == NULL || m_index->createGLResource() < 0)
            return -1;
        m_index_count= mesh->indiceCount();
        
        return 0;       // tout c'est bien passe
    }
    
    int quit( )         
    {
        // toutes les ressources seront liberees par shaderManager et bufferManager, etc.
        return 0;
    }
    
    int draw( )
    {
        if(key(SDLK_ESCAPE))
            // sortir si l'utilisateur appuye sur ESC
            Close();
        
        // redimensionner la fenetre, si necessaire.
        glViewport(0, 0, windowWidth(), windowHeight());
        // effacer le buffer de dessin.
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        
        // dessiner quelquechose.
    #if 0       // opengl historique
        gk::Transform perspective= gk::Perspective(50.f, 1.f, 1.f, 1000.f);
        gk::Transform view= gk::Translate( gk::Vector(0.f, 0.f, -50.f) );
        gk::Transform model;    // identite
        gk::Transform modelview= view * model;
        
        glMatrixMode(GL_PROJECTION);
        glLoadTransposeMatrixf( perspective.matrix() );
        
        glMatrixMode(GL_MODELVIEW);
        glLoadTransposeMatrixf( model_view.matrix() );
        
        glBindBuffer(GL_ARRAY_BUFFER, m_positions->name());
        glVertexPointer(3, GL_FLOAT, 0, NULL);
        glEnableClientState(GL_VERTEX_ARRAY);
        
        glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, m_index->name());
        glDrawElements(GL_TRIANGLES, m_index_count, GL_UNSIGNED_INT, NULL);
    #endif
    
    #if 1       // opengl core profile = shader necessaire.
        glUseProgram(m_program->name());
        
        gk::Transform perspective= gk::Perspective(50.f, 1.f, 1.f, 1000.f);
        gk::Transform view= gk::Translate( gk::Vector(0.f, 0.f, -50.f) );
        gk::Transform model;    // identite
        
        // passer la matrice model view projection au shader
        gk::Transform mvp= perspective * view * model;
        glUniformMatrix4fv( glGetUniformLocation(m_program->name(), "mvpMatrix"),
            1, GL_TRUE, mvp.matrix() );
        
        // parametrer les autres uniforms du shader
        glUniform4f( glGetUniformLocation(m_program->name(), "color"),
            1.f, .0f, .0f, 1.f);
            
        // activer les buffers d'attribut de sommets
        glBindBuffer(GL_ARRAY_BUFFER, m_positions->name());
        glVertexAttribPointer( glGetAttribLocation(m_program->name(), "position"), 
            3, GL_FLOAT, GL_FALSE, 0, NULL );
        // utiliser les buffers d'attributs...
        glEnableVertexAttribArray( glGetAttribLocation(m_program->name(), "position") );
        
        // activer le buffer d'indexation
        glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, m_index->name());
        // draw indexe, utilser le buffer d'indexation
        glDrawElements(GL_TRIANGLES, m_index_count, GL_UNSIGNED_INT, NULL);
        
        // remarque : conserver les identifiants des uniforms et des attributs (dans init apres le chargement du shader)
        // au lieu d'appeler glGetAttribLocation et glGetUniformLocation a chaque fois.
    #endif
        
        // afficher le dessin.
        SDL_GL_SwapBuffers();
        
        // continuer.
        return 1;
    }
};


int main( int argc, char *argv[] )
{
    TP app;
    app.run();
    
    return 0;
}
