
#ifndef _TEXTFILE_H
#define _TEXTFILE_H

#include <cstdio>
#include <string>
#include <vector>

#include "IOResource.h"

namespace gk {

//! representation d'une section d'un fichier texte.
struct TextSection
{
    std::string filename;
    int line;
    std::string text;
    
    TextSection( const std::string& _filename, const int _line= 1 )
        :
        filename(_filename),
        line(_line)
    {}
    
    TextSection( const std::string& _text, const std::string& _filename, const int _line )
        :
        filename(_filename),
        line(_line),
        text(_text)
    {}
};

//! stockage et lecture d'un fichier texte, source de shader, etc.
class TextFile : public IOResource
{
    std::vector<TextSection> m_definitions;
    std::vector<TextSection> m_sections;
    std::string m_name;
    
    int read( TextSection& section, FILE *in );
    
public:
    TextFile( const std::string& name )
        :
        m_name(name)
    {}
    
    ~TextFile( ) {}
    
    //! lecture du fichier 'filename'.
    int read( const std::string& filename );
    
    //! inclure le contenu du fichier 'filename', a la suite du contenu deja charge.
    int include( const std::string& filename );

    //! insere le contenu de 'source', a la suite du contenu deja charge.
    int include( const std::string& source, const std::string& filename, const int line );

    //! insere le contenu de 'source', a la suite du contenu deja charge.
    int include( const TextFile *text );
    
    //! insere une definition dans l'entete du fichier, a la suite des autres definitions.
    int define( const std::string& what, const std::string& value );

    //! renvoie le contenu du fichier sous forme de chaine de caracteres std::string.
    std::string string( ) const;
    
    //! renvoie une ligne du texte et son 'origine' : nom du fichier et numero de ligne 
    int getLine( const int line, std::string &string, std::string& file_name, int &file_line );
    
    //! renvoie le nom du fichier.
    const std::string& name( ) const
    {
        return m_name;
    }
    
    //! affiche le contenu du fichier.
    void print( ) const;
};

}       // namespace

#endif
