
#ifndef _TP_BUFFER_H
#define _TP_BUFFER_H

#include "GLResource.h"
#include "GL/GLPlatform.h"


namespace gk {

class GLBuffer : public GLResource
{
    GLuint m_name;
    GLenum m_target;
    int m_length;
    
public:
    GLBuffer( const GLenum target, const int length, const void *data, const GLenum usage= GL_STATIC_DRAW )
        :
        m_name(0),
        m_target(target),
        m_length(length)
    {
        glGenBuffers(1, &m_name);
        glBindBuffer(m_target, m_name);
        glBufferData(m_target, m_length, data, usage);
    }
    
    ~GLBuffer( )
    {
        glDeleteBuffers(1, &m_name);
    }
    
    //! creation de l'objet requete.
    int createGLResource( )
    {
        return (m_name != 0) ? 0 : -1;
    }
    
    //! destruction de l'objet requete.
    int releaseGLResource( )
    {
        return (m_name != 0) ? 0 : -1;
    }

    GLuint name( ) const
    {
        return m_name;
    }
    
    GLenum target( ) const
    {
        return m_target;
    }
    
    int length( ) const
    {
        return m_length;
    }
};

}

#endif
