
#include <cassert>

#include "Scene.h"

namespace gk {

Transform ISceneObject::getWorldTransform( )
{
    Transform world;
    if ( m_parent != NULL )
        world= m_parent->getWorldTransform();
        
    return world * m_local_transform;
}


int Scene::insert( const Name& name, ISceneObject *object )
{
    const int id = ( int ) m_objects.size();
    m_objects.push_back( object );
    if ( m_names.insert( std::make_pair( name, id ) ).second == true )
        return 0;
    else
    {
        // le nom est deja present
        m_objects.pop_back();
        return -1;
    }
}

ISceneObject *Scene::find( const Name& name ) const
{
    names_map::const_iterator i = m_names.find( name );
    if ( i != m_names.end() )
        return m_objects[i->second];
    else
        return NULL;
}

int Scene::draw( const Transform& view, const Transform& projection )
{
    const int n = ( int ) m_objects.size();
    for ( int i = 0; i < n; i++ )
    {
        assert( m_objects[i] != NULL );
        m_objects[i]->draw( view, projection );
    }
    
    return 0;
}

Scene::~Scene( ) 
{
    const int n = ( int ) m_objects.size();
    for ( int i = 0; i < n; i++ )
        delete m_objects[i];
}

}
