
#ifndef _MESH_MATERIAL_H
#define _MESH_MATERIAL_H

#include <string>

#include "IOResource.h"
#include "Geometry.h"

namespace gk {

//! representation d'une matiere.
struct MeshMaterial : public IOResource
{
    float m_kd; //!< diffus
    float m_kg; //!< reflechissant
    float m_kg_m;       //!< puissance du reflet
    float m_ks; //!< speculaire / miroir
    float m_ni; //!< indice de refraction
    
    Energy m_diffuse;    //!< couleur diffuse 
    Energy m_specular;   //!< couleur du reflet
    Energy m_transmission;   //!< couleur du 'relfet' refracte
    
    std::string m_diffuse_texture;      //!< nom de la texture.
    std::string m_glossy_texture;       //!< nom de la texture.
    std::string m_name;         //!< nom de la matiere.
    
    //! construction d'une matiere nommee.
    MeshMaterial( const std::string& name )
        :
        m_kd(.5f), 
        m_kg(0.f), m_kg_m(1.f), m_ks(0.f), m_ni(1.f),
        m_diffuse(1.f, 1.f, 1.f),
        m_name(name)
    {}
    
    //! destructeur.
    ~MeshMaterial( ) {}
};

}       // namespace

#endif

