
#include "TextFile.h"

namespace gk {
    
int TextFile::read( TextSection& section, FILE *in )
{
    char tmp[1024];
    for(;;)
    {
        if(fgets(tmp, sizeof(tmp), in) == NULL)
            break;
        
        // normalise les fins de lignes, \n pour windows, linux et mac os
        for(int i= 0; tmp[i] != 0; i++)
        {
            if(tmp[i] == '\r' && tmp[i+1] == '\n')
                // tmp[i+1] existe toujours, pas de reference apres la fin du tableau
                continue;
            
            if(tmp[i] == '\r')
                tmp[i]= '\n';
            section.text.push_back(tmp[i]);
        }
    }
    
    // force un saut de ligne a la fin du source
    section.text.push_back('\n');
    return 0;
}

int TextFile::read( const std::string& filename )
{
    FILE *in= fopen(filename.c_str(), "rt");
    if(in == NULL)
        return -1;
    
    m_sections.push_back( TextSection(filename) );
    int code= read(m_sections.back(), in);
    fclose(in);
    return code;
}

int TextFile::include( const std::string& filename )
{
    FILE *in= fopen(filename.c_str(), "rt");
    if(in == NULL)
        return -1;
    
    m_sections.push_back( TextSection(filename) );
    int code= read(m_sections.back(), in);
    fclose(in);
    return code;
}

//! insere le contenu de 'source', a la suite du contenu deja charge.
int TextFile::include( const std::string& source, const std::string& filename, const int line )
{
    m_sections.push_back( TextSection(source, filename, line) );
    return 0;
}

//! insere une definition dans l'entete du fichier, a la suite des autres definitions.
//! insere une ligne : #define what value
int TextFile::define( const std::string& what, const std::string& value )
{
    m_definitions.push_back( 
        TextSection("#define " + what + " " + value + "\n", "(definition)", 1) );
    return 0;
}

int TextFile::include( const TextFile *text )
{
    if(text == NULL)
        return -1;
    
    if(m_name.empty())
        m_name= text->m_name;
    
    m_definitions.insert(m_definitions.end(), 
        text->m_definitions.begin(), text->m_definitions.end());
    m_sections.insert(m_sections.end(),
        text->m_sections.begin(), text->m_sections.end());
    return 0;
}


//! renvoie le contenu du fichier sous forme de chaine de caracteres std::string.
std::string TextFile::string( ) const
{
    std::string text;
    
    int definitions_n= (int) m_definitions.size();
    for(int i= 0; i < definitions_n; i++)
        text.append(m_definitions[i].text);
    
    int sections_n= (int) m_sections.size();
    for(int i= 0; i< sections_n; i++)
        text.append(m_sections[i].text);
    
    return text;
}

void TextFile::print( ) const
{
    int definitions_n= (int) m_definitions.size();
    for(int i= 0; i < definitions_n; i++)
        printf("%s\n", m_definitions[i].text.c_str());
    
    int sections_n= (int) m_sections.size();
    for(int i= 0; i< sections_n; i++)
        printf("%s:%d\n%s\n", 
            m_sections[i].filename.c_str(), m_sections[i].line,
            m_sections[i].text.c_str());
}

int TextFile::getLine( const int line, std::string &string, std::string& file_name, int &file_line )
{
    file_name.clear();
    file_line= 0;
    
    if(line < 1)
        return -1;
    
    if(line < (int) m_definitions.size() +1)
    {
        string= m_definitions[line -1].text;
        file_name= m_definitions[line -1].filename;
        file_line= 1;
        return 0;
    }
    
    // parcourir les sections du texte
    int global_line= (int) m_definitions.size() +1;
    for(int i= 0; i < (int) m_sections.size(); i++)
    {
        const std::string& section= m_sections[i].text;

        int line_start= 0;
        int last_start= 0;
        int local_line= 1;
        for(int k= 0; k < (int) section.length(); k++)
        {
            line_start++;
            if(section[k] != '\n')
                continue;
            
            //~ printf("line %03d (%03d) %s", global_line, local_line, 
                //~ section.substr(last_start, line_start - last_start).c_str());
            if(line == global_line)
            {
                string= m_sections[i].text.substr(last_start, line_start - last_start);
                file_name= m_sections[i].filename;
                file_line= m_sections[i].line + local_line -1;
                return 0;
            }
            
            global_line++;
            local_line++;
            
            last_start= line_start;
        }
    }

    return -1;
}



}
