
#include "App.h"
#include "nvwidgets/nvSdlWidgets.h"


class UITuto : public gk::App
{
    nv::SdlUIContext m_ui;
    bool m_click;
    
public:
    UITuto( const int w, const int h )
        :
        gk::App(w, h),
        m_click(false)
    {
        m_ui.init(w, h);
    }
    
    ~UITuto( ) {}

    void processWindowResize( SDL_ResizeEvent& event )
    {
        m_ui.reshape(event.w, event.h);
    }
    
    void processMouseButtonEvent( SDL_MouseButtonEvent& event )
    {
        m_ui.processMouseButtonEvent(event);
    }
    
    void processMouseMotionEvent( SDL_MouseMotionEvent& event )
    {
        m_ui.processMouseMotionEvent(event);
    }
    
    void processKeyboardEvent( SDL_KeyboardEvent& event )
    {
        m_ui.processKeyboardEvent(event);
    }
    
    int draw( )
    {
        if(key(SDLK_ESCAPE))
            Close();
        
        glViewport(0, 0, windowWidth(), windowHeight());
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        
        m_ui.begin();
            m_ui.beginGroup(nv::GroupFlags_GrowDownFromLeft);
                m_ui.doCheckButton(nv::Rect(), "Button", &m_click);
            m_ui.endGroup();
        m_ui.end();
        
        SDL_GL_SwapBuffers();
        
        return 1;
    }
};

int main( int argc, char *argv[] )
{
    UITuto app(600, 600);
    app.run();
    
    return 0;
}
