
#include "Geometry.h"
#include "GL/GLPlatform.h"
#include "ShaderManager.h"

#include "App.h"

class TP : public gk::App
{
    gk::GLShaderProgram *m_program;
    GLint m_program_color;
    
public:
    TP( const int w= 1024, const int h=768 )
        :
        gk::App(w, h)
    {}
    
    ~TP( ) {}
    
    int init( )
    {
    #if 0
        // solution 1 : gestion manuelle des ressources openGL
        m_program= new gk::GLShaderProgram("simple.vsl", "simple.gsl", "simple.fsl");
        if(m_program == NULL || m_program->createGLResource() < 0)
            return -1;
        
    #else
        // solution 2 : gestion "auto" des ressources openGL
        m_program= gk::createShaderProgram("simple.vsl", "simple.fsl");
        if(m_program == NULL || m_program->createGLResource() < 0)
            return -1;
        // c'est surtout la liberation des ressources qui change, cf quit()
    #endif
        
        // recuperer l'identifiant de 'color'
        m_program_color= glGetUniformLocation(m_program->name(), "color");
        
        return 0;
    }
    
    int quit( )
    {
    #if 0
        // solution 1 : gestion manuelle des ressources openGL
        if(m_program != NULL)
        {
            // liberer les ressources openGL
            m_program->releaseGLResource();
            // liberer l'objet
            delete m_program;
        }
    #else
        // solution 2 : gestion 'auto' des ressources openGL
        // ... rien a faire, ShaderManager / gk::GLManager<gk::GLShaderProgram> fait tout.
    #endif
        return 0;
    }
    
        
    int draw( )
    {
        if(key(SDLK_ESCAPE))
            Close();
        
        glViewport(0, 0, windowWidth(), windowHeight());
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        
        glUseProgram(m_program->name());
        glUniform4f(m_program_color, 1.f, 0.f, 0.f, 0.f);
        
        SDL_GL_SwapBuffers();
        
        return 1;
    }
};

int main( int argc, char *argv[] )
{
    TP app;
    app.run();
    
    return 0;
}
