
#include "Geometry.h"
#include "Transform.h"

#include "Triangle.h"
#include "PNTriangle.h"

#include "MeshIO.h"
#include "ImageIO.h"

// calcule la transformation complete d'un point p
gk::HPoint transform( const gk::Point& p, const gk::Transform& mvp )
{
    gk::HPoint ph;      // point homogene resultat de la projection
    mvp(p, ph);         // transforme le point
    return ph;
}

// verifie que le point transforme est visible, si c'est le cas, determine le pixel sur lequel il se projette.
int clip( const gk::HPoint& ph, const gk::Transform& viewport, gk::Point& q )
{
    if(ph.isCulled())
        return 0;
    
    q= viewport(ph.project());
    return 1;
}

// enchaine la transformation et la projection sur le pixel (suppose que le point est visible)
gk::Point transform_clip( const gk::Point& p, const gk::Transform& mvp, const gk::Transform& viewport )
{
    gk::HPoint ph;      // point homogene resultat de la projection
    mvp(p, ph);         // transforme le point

    gk::Point q;
    if(ph.isCulled())   // verifie quand meme la visibilite 
        return q;       // (0, 0, 0) si le point n'est pas visible.
    
    q= viewport(ph.project());
    return q;
}

int main( )
{
    // charger un objet
    gk::Mesh *mesh= gk::MeshIO::read("bigguy.obj");
    
    // creer une image resultat
    gk::Image *image= new gk::Image(1024, 768);
    
    // definir les transformations
    gk::Transform model= gk::Translate( gk::Vector(10.f, 0.f, 0.f) ) * gk::RotateY(30.f);
    //~ gk::Transform model;
    
    gk::Transform view= gk::Translate( gk::Vector(0.f, 0.f, -50.f) );   // recule la camera pour observer tout l'objet
    gk::Transform projection= gk::Perspective(50.f, 1.f, 1.f, 1000.f);  // projection perspective
    gk::Transform viewport= gk::Viewport(image->width(), image->height());      // transformation adaptee a la resolution de l'image resultat

    // compose les transformations, sauf viewport : produit dans le sens inverse des changements de reperes representes ...
    gk::Transform mvp= projection * view * model;
    
    // parcourir tous les triangles de l'objet
    const int triangles_n= mesh->triangleCount();
    for(int i= 0; i < triangles_n; i++)
    {
        // recupere un triangle
        gk::Triangle triangle= mesh->getTriangle(i);
        const gk::MeshMaterial &material= mesh->triangleMaterial(i);
        printf("material '%s': %f %f %f, Ns %f, Ni %f\n", 
            material.m_name.c_str(),
            material.m_diffuse.r, material.m_diffuse.g, material.m_diffuse.b,
            material.m_kg_m, material.m_ni);
        
        // transforme les sommets du triangle abc
        gk::HPoint ah= transform(triangle.a, mvp);
        gk::HPoint bh= transform(triangle.b, mvp);
        gk::HPoint ch= transform(triangle.c, mvp);
        
        // verifie la visibilite des sommets transformes
        gk::Point at, bt, ct;
        int clip_n= 0;
        clip_n+= clip(ah, viewport, at);
        clip_n+= clip(bh, viewport, bt);
        clip_n+= clip(ch, viewport, ct);
        if(clip_n == 0)
            // aucun sommet n'est visible, plus rien a faire
            continue;
        
        // afficher les sommets du triangle
        gk::Pixel blanc(255, 255, 255);
        
        // generer un ensemble de points dans le triangle pour le dessiner
        // utiliser p(u, v)= u*a + v*b + (1-u-v)*c et parcourir le plan [0..1]x[0..1]
        for(float u= 0.f; u < 1.f; u+= .1f)
        {
            // pas arbitraire, non adapte a la projection du triangle dans l'image
            for(float v= 0.f; v < 1.f - u; v+= .1f)
            {
                // determine w ...
                float w= 1 - u - v;
                // et verifie que le point est bien contenu dans le triangle : 0 < u + v + w < 1
                if(w < 0.f || w > 1.f)
                    continue;   // u + v + w ne correspond pas a l'interieur du triangle, continuer.
                
                gk::Point p= u * triangle.a + v * triangle.b + w * triangle.c;
                // projette directement le point sur un pixel
                gk::Point pt= transform_clip(p, mvp, viewport);

                // dessine le pixel ...
                image->setPixel(pt.x, pt.y, blanc);
            }
        }
    }
    
    // enregistrer l'image
    gk::ImageIO::write(image, "render.bmp");
    delete image;
    
    // pas la peine de detruire l'objet mesh, gk::MeshIO le fait automatiquement.
    return 0;
}
