
#include "GL/TPShaderProgram.h"

namespace gk {
    
//! ajoute un shader object au shader program.
int GLShaderProgram::attachShader( GLShaderObject *shader )
{
    if(shader == NULL)
    {
    #ifdef VERBOSE
        printf("GLShaderProgram( ): warning, no shader object.\n");
    #endif
        return 0;
    }
    
    GLenum shader_type= shader->type();
    const int n= (int) m_shaders.size();
    for(int i= 0; i < n; i++)
        if(m_shaders[i]->type() == shader_type)
        {
        #ifdef VERBOSE
            printf("GLShaderProgram( ): error duplicate shader object (type 0x%x).\n", 
                shader_type);
        #endif
            return -1;
        }
    
    m_shaders.push_back(shader);
    return 0;
}


int GLShaderProgram::createGLResource( )
{
    m_name= glCreateProgram();
    if(m_name == 0)
        return -1;
    
    return make();
}

int GLShaderProgram::releaseGLResource( )
{
    if(m_name != 0)
        glDeleteProgram(m_name);
    
    m_name= 0;
    m_is_linked= false;
    m_is_validated= false;
    return 0;    
}

//! construit le shader program.
int GLShaderProgram::make( )
{
    if(m_name == 0)
        return -1;
    
    const int n= (int) m_shaders.size();
    for(int i= 0; i < n; i++)
    {
        const GLenum type= m_shaders[i]->type();
        if(m_shaders[i]->createGLResource() < 0)
        {
        #ifdef VERBOSE
            printf("GLShaderProgram( ): error compiling shader object (type 0x%x).\n", 
                type);
        #endif
            return -1;
        }
        
        glAttachShader(m_name, m_shaders[i]->name());
    }
    
    return link();
}

//! (re-)linke le shader program.
int GLShaderProgram::link( )
{
    if(m_name == 0)
        return -1;
    if(m_is_linked == true)
        return 0;
    
    GLint code;
    glLinkProgram(m_name);
    glGetProgramiv(m_name, GL_LINK_STATUS, &code);
    if(code == GL_FALSE)
    {
        GLint length= 0;
        glGetShaderiv(m_name, GL_INFO_LOG_LENGTH, &length);
        if(length == 0)
        {
            printf("GLShaderProgram( ): error linking shader program (no info log).\n");
            return -1;
        }
        
        // afficher les erreurs de link
        GLchar *log= new GLchar[length];
        glGetProgramInfoLog(m_name, (GLsizei) length, NULL, log);
        
        printf("GLShaderProgram( ): error linking shader program:\n%s\n", log);
        delete [] log;
        return -1;
    }

    m_is_linked= true;        
    return 0;    
}
    
//! valide la configuration du shader program.
int GLShaderProgram::validate( )
{
    if(m_name == 0)
        return -1;
    if(m_is_linked == false)
        return -1;
    
    GLint code;
    glValidateProgram(m_name);
    glGetProgramiv(m_name, GL_VALIDATE_STATUS, &code);
    if(code == GL_FALSE)
    {
        GLint length= 0;
        glGetShaderiv(m_name, GL_INFO_LOG_LENGTH, &length);
        if(length == 0)
        {
            printf("GLShaderProgram( ): error validating shader (no info log).\n");
            return -1;
        }
        
        GLchar *log= new GLchar[length];
        glGetProgramInfoLog(m_name, (GLsizei) length, NULL, log);
        
        printf("GLShaderProgram( ): error validating shader:\n%s\n", log);
        delete [] log;            
        return -1;
    }
    
    m_is_validated= true;
    return 0;
}

}
