
#ifndef _RENDER_TARGET_H
#define _RENDER_TARGET_H

#include <GL/glew.h>
#include <GL/gl.h>

typedef struct
{
    GLuint fb;  // color render target
    GLuint tex; // texture
    GLuint depthTex; // depth texture

    // texture dimensions
    int texWidth;
    int texHeight;
    
    // texture format
    GLenum texInternalFormat;
    GLenum texTarget;
    GLenum filterMode;
    int maxCoordS;
    int maxCoordT;
} RENDER_TARGET;


extern int render_target_init();
extern int render_target_quit();

extern int render_target_disable();

extern RENDER_TARGET *render_target_create_format(int w, int h, GLenum texTarget, GLint texFormat, GLenum depthFormat);
extern RENDER_TARGET *render_target_create(int w, int h);
extern int render_target_delete(RENDER_TARGET *target);

extern int render_target_get_viewport(RENDER_TARGET *target, int viewport[4]);

extern int render_target_bind(RENDER_TARGET *target);

extern int render_target_bind_texture(RENDER_TARGET *target);
extern int render_target_bind_depth_texture(RENDER_TARGET *target);

#endif
