/*
    bmp_texture.c
    
    . charge une image bmp et construit une texture openGL
    . enregistre l'image courante dans une image bmp
    
    mailto:jean-claude.iehl@liris.cnrs.fr
    fevrier 2008
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <GL/gl.h>
#include "sdlkit.h"

#if SDL_BYTEORDER == SDL_LIL_ENDIAN /* OpenGL RGBA masks */
    #define RMASK 0x000000FF
#else
    #define RMASK 0xFF000000
#endif

int bmp_load_texture(GLuint tex, char *fname)
{
    SDL_Surface *bmp;
    GLuint bmpFormat;
    GLuint texFormat;
    int code;
    
    bmp= SDL_LoadBMP(fname);
    if(bmp == NULL)
    {
    #if VERBOSE
        printf("texture '%s' failed.\n", fname);
    #endif
        return -1;
    }
    
    code= -1;
    if(bmp->format->BytesPerPixel == 3)
    {
        texFormat= GL_RGB;
        if(bmp->format->Rmask == RMASK)
            bmpFormat= GL_RGB;
        else
            bmpFormat= GL_BGR;
        
    //~ #if VERBOSE
        printf("texture '%s' : rgb\n", fname);
    //~ #endif
    }
    else if(bmp->format->BytesPerPixel == 4)
    {
        texFormat= GL_RGBA;
        if(bmp->format->Rmask == RMASK)
            bmpFormat= GL_RGBA;
        else
            bmpFormat= GL_BGRA;
        
    //~ #if VERBOSE
        printf("texture '%s' rgba.\n", fname);
    //~ #endif
    }
    else
    {
    #if VERBOSE
        printf("texture '%s' format failed.\n", fname);
    #endif
        goto error;
    }
    code= 0;
    glBindTexture(GL_TEXTURE_2D, tex);

    glTexParameteri(GL_TEXTURE_2D, GL_GENERATE_MIPMAP, GL_TRUE); // todo flag 
    
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);

    glTexImage2D(GL_TEXTURE_2D, 0, texFormat, bmp->w, bmp->h, 0, 
        bmpFormat, GL_UNSIGNED_BYTE, bmp->pixels);
    
error:
    SDL_FreeSurface(bmp);
    return code;
}


int bmp_screenshot(char *fname)
{
    int viewport[4];
    SDL_Surface *bmp;
    unsigned char *data;
    int code;
    
    sdlkit_get_viewport(viewport);
    data= (unsigned char *) malloc(sizeof(unsigned char[3]) * viewport[2] * viewport[3]);
    assert(data != NULL);
    
    glReadPixels(0, 0, viewport[2], viewport[3], 
        GL_RGB, GL_UNSIGNED_BYTE, data);
    
    bmp= SDL_CreateRGBSurfaceFrom(data, viewport[2], viewport[3], 
        24, viewport[2] * 3, 
        0xFF0000,
        0x00FF00, 
        0x0000FF,
        0x00
        );
    
    code= SDL_SaveBMP(bmp, fname);
    SDL_FreeSurface(bmp);
    free(data);
    
    return code;
}

