#include <GL/gl.h>

#include "sdlkit.h"

void color_display( int r, int g, int b )
{
    glColor3ub(r & 255, g & 255, b & 255);
}

void point_display( int x, int y )
{
    glBegin(GL_POINTS);
        glVertex2i(x, y);
    glEnd();
}

void line_display( int x0, int y0, int x1, int y1 )
{
    glBegin(GL_LINES);
        glVertex2i(x0, y0);
        glVertex2i(x1, y1);
    glEnd();
}

void display_begin( void )
{
    glClearColor(0.0, 0.0, 0.0, 0.0); 
    glClearDepth(1.0); 
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glPointSize(2.f);
    glLineWidth(2.f);

    int viewport[4];
    sdlkit_get_viewport(viewport);
    glViewport(viewport[0], viewport[1], viewport[2], viewport[3]);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho(0.0,viewport[2], 0.0, viewport[3], -1.0, 1.0);
    
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
}

void display_end( void )
{
    SDL_GL_SwapBuffers();
}


int min3i( int a, int b, int c )
{
    int m;
    
    m= a;
    if(b < m)
        m= b;
    if(c < m)
        m= c;
    
    return m;
}

int max3i( int a, int b, int c )
{
    int m;
    
    m= a;
    if(b > m)
        m= b;
    if(c > m)
        m= c;
    
    return m;
}

/* calcule l'aire signee d'un triangle abc 
    > 0 si le triangle est decrit dans le sens trigo 
    < 0 sinon (sens horaire)
 */
inline int triangle_area(
    int ax, int ay,
    int bx, int by,
    int cx, int cy )
{
    return ((bx - ax) * (cy - ay) - (cx - ax) * (by - ay)) / 2;
}

/* remplissage du triangle a, b, c avec la couleur active */
void triangle_display(
    int ax, int ay,
    int bx, int by,
    int cx, int cy )
{
    int xmin, xmax;
    int ymin, ymax;
    
    /* determine le rectangle englobant du triangle */
    xmin= min3i(ax, bx, cx);
    xmax= max3i(ax, bx, cx);
    ymin= min3i(ay, by, cy);
    ymax= max3i(ay, by, cy);
    
    /* ne conserve que la partie affichable du rectangle */
    /*   .  recupere la taille de la fenetre d'affichage */
    int w, h;
    int viewport[4];
    sdlkit_get_viewport(viewport);
    
    if(xmin < 0)
        xmin= 0;
    if(xmax >= viewport[2])
        xmax= viewport[2] -1;
    if(ymin < 0)
        ymin= 0;
    if(ymax >= viewport[3])
        ymax= viewport[3] -1;

    /* teste l'inclusion de tous les points du rectangle */
    int x, y;
    for(y= ymin; y <= ymax; y+= 1)
    {
        for(x= xmin; x <= xmax; x+= 1)
        {
            int pab, pbc, pca;
            
            /* calcule l'aire signee des triangles pab, pbc, pca */
            pab= triangle_area(x, y, ax, ay, bx, by);
            pbc= triangle_area(x, y, bx, by, cx, cy);
            pca= triangle_area(x, y, cx, cy, ax, ay);
            
            if(pab >= 0 && pbc >= 0  && pca >= 0)
                /* le point (x, y) est a l'interieur du triangle */
                point_display(x, y);
        }
    }
}

