#ifdef _WIN32
#include <windows.h>
#else
#include <unistd.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

#include <SDL/SDL.h>
#include <GL/gl.h>
#include <GL/glu.h>

#include "model.h"


static int stop= 0;
static const SDL_VideoInfo *screen_info= NULL;
static SDL_Surface *screen= NULL;

static void *scene= NULL;
static char *scene_fname= NULL;
static void (*display_scene)(void *)= NULL;

// position et orientation du point de vue
static float camera_x, camera_y, camera_z;
static float camera_angle, camera_angle2;
static float camera_vitesse;

static int lumiere;

// timer pour l'animation
static int timer;
static int timer_rate;

// conversion degres vers radians
static float radians(float d)
{
    return d * 0.0174532925f;
}

static void camera_pref_fname(char *pref, char *scene_fn)
{
    char *ext;

    // construit le nom du fichier de preference pour le modele
    strcpy(pref, scene_fn);
    ext= strrchr(pref, '.');
    if(ext==NULL)
        ext= pref;
    
    strcpy(ext, ".mob");
}

static void camera_coller(void)
{
    char pref_fn[1024];
    FILE *in;
    float x, y, z, v, a, b;
    
    camera_pref_fname(pref_fn, scene_fname);
    in= fopen(pref_fn, "rt");
    if(in==NULL)
        return;
    
    if(fscanf(in, "x %f y %f z %f v %f a %f b %f ", 
        &x, &y, &z, &v, 
        &a, &b)==6)
    {
        camera_x= x;
        camera_y= y;
        camera_z= z;
        camera_vitesse= v;
        camera_angle= a;
        camera_angle2= b;
    }
    
    fclose(in);
}

static void camera_copier(void)
{
    char pref_fn[1024];
    FILE *out;
    
    camera_pref_fname(pref_fn, scene_fname);
    out= fopen(pref_fn, "wt");
    if(out==NULL)
        return;
    
    fprintf(out, "x %f y %f z %f\nv %f\na %f b %f\n", 
        camera_x, camera_y, camera_z, camera_vitesse, 
        camera_angle, camera_angle2);
    
    fclose(out);
}

// affichage
static void display(void)
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    glMatrixMode(GL_PROJECTION);	// selectionne la matrice de visualisation
    glLoadIdentity();				// reinitialise les transformations
    //~ gluPerspective(50., (float) screen->clip_rect.w / (float) screen->clip_rect.h, 1., 10000.);
    gluPerspective(50., 1. , 1., 10000.);
  
    glMatrixMode(GL_MODELVIEW);		// selectionne la matrice de la scene
    glLoadIdentity();				// reinitialise les transformations

    if(lumiere!=0)
    {
        GLfloat mat_specular[] = { 1.0f, 1.0f, 1.0f, 1.0f };
        GLfloat mat_shininess[] = { 20.0f };
        GLfloat light_position[] = { 0.0f, 1.0f, 1.0f, 0.0f };
        
        glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
        glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
        glLightfv(GL_LIGHT0, GL_POSITION, light_position);
        
        glEnable(GL_LIGHTING);
        glEnable(GL_LIGHT0);
        glPolygonMode(GL_FRONT, GL_FILL);
        glPolygonMode(GL_BACK, GL_FILL);
    }
    else
    {
        glDisable(GL_LIGHTING);
        glPolygonMode(GL_FRONT, GL_LINE);
        glPolygonMode(GL_BACK, GL_LINE);
    }
    
    // oriente la scene par rapport a la camera qui est restee en 0,0,0
    glRotatef(360.f - camera_angle2, 1.f, 0.f, 0.f);
    glRotatef(360.f - camera_angle, 0.f, 1.f, 0.f);
    glTranslatef(-camera_x, -camera_y, -camera_z);

    // desssine la scene
    display_scene(scene);
    
    SDL_GL_SwapBuffers();
}

// callback de glut : appellee regulierement
static void anime(void)
{
    // attente
    SDL_Delay(1000. / timer_rate);
    
    timer++;
}

static void keyboard(SDL_Event *event)
{
   SDLMod mod;
    
    mod= SDL_GetModState();
    
    switch(event->key.keysym.sym)
    {
        case SDLK_q:
        case SDLK_ESCAPE:
            stop= 1;
        break;

        case SDLK_c:
            camera_copier();
        break;

        case SDLK_v:
            camera_coller();
        break;
        
        case SDLK_SPACE:
            lumiere= (lumiere +1) %2;
        break;
        
        case SDLK_KP_PLUS:
            if(mod&KMOD_CTRL || mod&KMOD_ALT)
                camera_vitesse+= .01f;
            else
                camera_vitesse+= 2.f;
            printf("camera speed %f\n", camera_vitesse);
        break;

        case SDLK_KP_MINUS:
            if(mod&KMOD_CTRL || mod&KMOD_ALT)
                camera_vitesse-= .01f;
            else
                camera_vitesse-= 2.f;
            
            if(camera_vitesse < 0.f)
                camera_vitesse= 0.f;
            printf("camera speed %f\n", camera_vitesse);
        break;

        case SDLK_HOME:
            camera_x= 0.f;
            camera_y= 0.f;
            camera_z= 50.f;
            camera_angle= 0.f;
            camera_angle2= 0.f;
            camera_vitesse= 5.f;
        break;
        
        // navigation
        case SDLK_UP:
            if(mod&KMOD_CTRL || mod&KMOD_ALT)
            {
                // rotation de la camera sur X
                camera_angle2+= 1.;
                if(camera_angle2 >= 360.)
                        camera_angle2= 0.;
            }
            else
            {
                // deplacement de la camera dans la direction de la visee
                if(mod&KMOD_SHIFT)
                {
                    camera_z-= cos(radians(camera_angle)) * camera_vitesse * 10;
                    camera_x-= sin(radians(camera_angle)) * camera_vitesse * 10;
                }
                else
                {
                    camera_z-= cos(radians(camera_angle)) * camera_vitesse;     
                    camera_x-= sin(radians(camera_angle)) * camera_vitesse;
                }
            }
        break;

        case SDLK_DOWN:
            if(mod&KMOD_CTRL || mod&KMOD_ALT)
            {
                // rotation de la camera sur Y+
                camera_angle2-= 1.;
                if(camera_angle2 < 0.)
                    camera_angle2= 359.;
            }
            else
            {
                // deplacement de la camera dans la direction opposee de la visee
                if(mod&KMOD_SHIFT)
                {
                    camera_z+= cos(radians(camera_angle)) * camera_vitesse * 10;
                    camera_x+= sin(radians(camera_angle)) * camera_vitesse * 10;
                }
                else
                {
                    camera_z+= cos(radians(camera_angle)) * camera_vitesse;
                    camera_x+= sin(radians(camera_angle)) * camera_vitesse;
                }
            }
        break;

        case SDLK_LEFT:
            if(mod&KMOD_CTRL || mod&KMOD_ALT)
            {
                // rotation de la camera sur Y-
                camera_angle+= 1.;
                if(camera_angle >= 360.)
                    camera_angle= 0.;
            }
            else
            {
                // deplacement perpendiculaire a la direction de visee
                camera_z-= cos(radians(camera_angle + 90.)) * camera_vitesse;
                camera_x-= sin(radians(camera_angle + 90.)) * camera_vitesse;
            }
        break;

        case SDLK_RIGHT:
            if(mod&KMOD_CTRL || mod&KMOD_ALT)
            {
                // rotation de la camera sur Y+
                camera_angle-= 1.;
                if(camera_angle < 0.)
                    camera_angle= 359.;
            }
            else
            {
                // deplacement perpendiculaire a la direction de visee
                camera_z-= cos(radians(camera_angle - 90.)) * camera_vitesse;
                camera_x-= sin(radians(camera_angle - 90.)) * camera_vitesse;
            }
        break;

        case SDLK_PAGEUP:
            camera_y+= camera_vitesse;
        break;
        
        case SDLK_PAGEDOWN:
            camera_y-= camera_vitesse;
        break;
                
        default:
            break;
    }
}

static int resize(int width, int height)
{
    screen_info= SDL_GetVideoInfo();
    if(screen_info==NULL)
    {
        printf("\n -- failed: '%s'\n", SDL_GetError());
        SDL_Quit();
        return -1;
    }
    
    SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 24);
    SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
    
    screen= SDL_SetVideoMode(width, height, 
            screen_info->vfmt->BitsPerPixel, 
            SDL_RESIZABLE | SDL_OPENGL | SDL_HWSURFACE);
    if(screen==NULL)
    {
        printf("\n -- failed: '%s'\n", SDL_GetError());
        SDL_Quit();
        return -1;
    }

    return 0;
}

static int initsdl(int width, int height)
{
    if(SDL_Init(SDL_INIT_NOPARACHUTE | SDL_INIT_VIDEO) < 0)
    { 
        printf("\n -- failed : '%s'\n", SDL_GetError());
        return -1;
    }

    SDL_EnableKeyRepeat(SDL_DEFAULT_REPEAT_DELAY, 20);
    
    atexit(SDL_Quit);
    resize(width, height);
    return 0;
}


// mise en place des parametres d'openGL
static void initgl(void)
{
    glClearColor(0.0, 0.0, 0.0, 0.0);
    glClearDepth(1.);

    glShadeModel (GL_SMOOTH);
    
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_CULL_FACE);
    //~ glDisable(GL_CULL_FACE);
    glCullFace(GL_BACK);

    glFrontFace(GL_CCW);
    
    camera_x= 0.f;
    camera_y= 0.f;
    camera_z= 50.f;
    camera_angle= 0.f;
    camera_vitesse= 5.f;

    timer= 0;
    timer_rate= 50;	// frequence d'affichage
    
    lumiere= 0;
}

static void process_events(void)
{
    SDL_Event event;

    while(SDL_PollEvent(&event))
    {
        switch(event.type)
        {
            // case SDL_KEYUP:
            case SDL_KEYDOWN:
                keyboard(&event);
                break;
            
            case SDL_VIDEORESIZE:
                resize(event.resize.w, event.resize.h);
                break;
            
            case SDL_QUIT:
                stop= 1;
                break;
        }
    }
}


int view_init(int *argc, char ***argv)
{
    if(initsdl(600, 600) < 0)
    {
        printf("\n -- failed: '%s'\n", SDL_GetError());
        return -1;
    }
    SDL_WM_SetCaption("object viewer", "");
    
    initgl();
    
    return 0;
}

void view(void (*displayfunc)(void *), void *param, char *fname)
{
    scene= param;
    scene_fname= fname;
    display_scene= displayfunc;
    
    while(!stop)
    {
        process_events();
        anime();
        display();
    }
}
