/*
	scenes off
	
	mailto:jciehl@bat710.univ-lyon1.fr
	mai 2004
	fevrier 2006
	
        cf. "geomview off fileformat"
        http://people.scs.fsu.edu/~burkardt/data/off/off.html
        
	TODO : 
		verification du format
		detection d'erreurs correcte 
		elimination des commentaires
                chargement des couleurs de sommets et des faces 
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>

#include "model.h"


int model_is_off(char *filename)
{
	char *ext;
	
	ext= strrchr(filename, '.');
	if(ext!=NULL && strcmp(ext, ".off")==0)
		return 0;
	else
		return -1;
}

int model_load_off(MODEL **pmodel, char *filename)
{
	char header[128];
	MODEL *model;
	FACE *face;
	FILE *in;
	int code= 0;
	int tmp, triangles_n;
	int i, j;
	char c;
	
	model= NULL;
	*pmodel= NULL;

	in= fopen(filename, "rt");
	if(in==NULL)
		return -1;

	if(fgets(header, sizeof(header), in)==NULL
	|| strncmp(header, "OFF", 3)!=0)
		goto error;
	
	model= model_new(filename);

	array_add(ARRAY(&model->mat), &model->mat_size, 
		0, 
		sizeof(MATERIAL), MODEL_MATERIAL_MORE);
	model->mat[0].name= strdup("default");
	model->mat_n++;
		
	
	code= fscanf(in, " %d %d %d \n", &model->v_n, &model->faces_n, &tmp);
	if(code!=3)
		goto error;
	
	array_add(ARRAY(&model->v), &model->v_size, 
		model->v_n -1, 
		sizeof(VERTEX), MODEL_VERTEX_MORE);
	for(i= 0; i < model->v_n; i++)
	{
		code= fscanf(in, " %f %f %f", 
			&model->v[i][0], &model->v[i][1], &model->v[i][2]);
		if(code!=3)
		{
			printf("  -- bad vertex data\n");
			goto error;
		}
		
		for(;;)
		{
			c= fgetc(in);
			// printf("%c", c);
			if(c==EOF || c=='\n')
				break;
		}
	}
	
	triangles_n= 0;
	array_add(ARRAY(&model->faces), &model->faces_size, 
		model->faces_n -1, 
		sizeof(FACE), MODEL_FACE_MORE);
	for(i= 0; i < model->faces_n; i++)
	{
		face= &model->faces[i];
		face->attr= model->attr_n;
		face->norm= -1;
		face->mat= 0;

		if(fscanf(in, " %d ", &face->n) != 1)
		{
			printf("  -- bad face data\n");
			goto error;
		}
		
		if(face->n==3)
			triangles_n++;
		
		for(j= 0; j < face->n; j++)
		{
			array_add(ARRAY(&model->attr), &model->attr_size,
				model->attr_n, 
				sizeof(ATTR), MODEL_ATTR_MORE);
			model->attr[model->attr_n][gl_tex]= -1;
			model->attr[model->attr_n][gl_norm]= -1;
			code= fscanf(in, " %d", &model->attr[model->attr_n][gl_vertex]);
			if(code!=1)
			{	
				printf("  -- bad index data\n");
				goto error;
			}
			model->attr_n++;
		}
		
		for(;;)
		{
			c= fgetc(in);
			// printf("%c", c);
			if(c==EOF || c=='\n')
				break;
		}
	}
	
	fclose(in);
	
	//
	if(triangles_n==model->faces_n)
		model->flags|= MODEL_IS_TRIANGLES;
	
	model_print_stat(model);
	
	*pmodel= model;	
	return 0;
	
error:
	if(fgets(header, sizeof(header), in)!=NULL)
	{
		header[sizeof(header) -1]= 0;
		printf("line : %s", header);
	}	
	fclose(in);
        
	model_free(model);
	return -1;
}
