#include <GL/glew.h>
#include <SDL/SDL.h>

#include "sdlkit.h"
#include "glsl2.h"

GLuint program;
GLint param;

void display_frame(float x, float y, float z, float w, float h)
{
    glColor3f(1.f, 1.f, 1.f);

    /* fixe la valeur des parametres */
    glUniform4f(param, .8f, .5f, .5f, 1.f);

    /* dessiner quelquechose */
    glBegin(GL_QUADS);
        glVertex3f(x, y+h, z);
        glVertex3f(x, y, z);
        glVertex3f(x+w, y, z);
        glVertex3f(x+w, y+h, z);
    glEnd();
}

void display(void)
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    glMatrixMode(GL_MODELVIEW);	// selectionne la matrice de la scene
    glLoadIdentity();				// reinitialise les transformations

    display_frame(0.25f, 0.25f, 0.f, .5f, .5f);
    SDL_GL_SwapBuffers();
}

void initgl(int w, int h)
{
    glClearColor(0.0, 0.0, 0.0, 0.0);
    glClearDepth(1.);

    glShadeModel (GL_SMOOTH);
    
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_CULL_FACE);

    glMatrixMode(GL_PROJECTION);	// selectionne la matrice de la scene
    glLoadIdentity();				// reinitialise les transformations
    glOrtho(0.0, 1.0, 0.0, 1.0, -1.0, 1.0);
    glViewport(0, 0,  w, h);
}

int main(void)
{
    unsigned char *keys;
    
   /* creation de la fenetre / contexte openGL */
    sdlkit_init(600, 600);
    /* prepare l'utilisation des shaders*/
    glsl_init();
    
    /* charge les shaders et assemble le programme */
    program= glsl_program_init("simple.vsl","simple.fsl");
    if(program==0)
        return -1;
    
    /* active le programme */
    glUseProgram(program);
    
    /* recupere les parametres */
    param= glGetUniformLocation(program, "couleur");
    printf("param %d\n", param);
    
    /* initialise projection, etc. */
    initgl(600, 600);
    
    /* recupere l'etat des touches */
    keys= sdlkit_get_keys();
    
    /* tant que la fenetre n'est pas fermee */
    while(!sdlkit_stop())
    {
        /* traite les evenements */
        sdlkit_events();
        
        /* sortir du programme si Q ou ESCAPE est enfoncee */
        if(keys[SDLK_q] || keys[SDLK_ESCAPE])
            break;

        /* limiter la vitesse d'affichage */
        sdlkit_anime();
        
        /* afficher la scene */
        display();
    }
   
    /* c'est fini */
    glsl_quit();
    sdlkit_quit();
    printf("\ndone.\n");
    return 0;
}


/* simple vertex shader
    void main(void)
    {
        gl_Position=gl_ModelViewProjectionMatrix * gl_Vertex;
    }
*/

/*  fragment shader
    uniform vec4 couleur;

    void main(void)
    {
        gl_FragColor= couleur;
    }
*/
