
#ifndef _VERTEX_BUFFER_H
#define _VERTEX_BUFFER_H

#include <GL/glew.h>
#include <GL/gl.h>

#define VBO_ATTR_MAX 16

enum 
{
    DISABLE_ATTR= 0, 
    INDEX_ATTR= 1, 
    VERTEX_ATTR, 
    COLOR_ATTR, 
    TANGENT_ATTR, BINORMAL_ATTR, NORMAL_ATTR,
    TEXCOORD0_ATTR, TEXCOORD1_ATTR, TEXCOORD2_ATTR, TEXCOORD3_ATTR, 
    VERTEXATTR0_ATTR, VERTEXATTR1_ATTR, VERTEXATTR2_ATTR, VERTEXATTR3_ATTR,
    OBJECTID_ATTR,
    
    ATTR_N
};

#define ATTR_BIT(a) (1<<a)

#define DISABLE_BIT (1<<DISABLE_ATTR)

#define INDEX_BIT (1<<INDEX_ATTR)
#define VERTEX_BIT (1<<VERTEX_ATTR)
#define COLOR_BIT (1<<COLOR_ATTR)

#define TANGENT_BIT (1<<TANGENT_ATTR)
#define BINORMAL_BIT (1<<BINORMAL_ATTR)
#define NORMAL_BIT (1<<NORMAL_ATTR)

#define TEXCOORD_BIT (1<<TEXCOORD0_ATTR)
#define TEXCOORD0_BIT (1<<TEXCOORD0_ATTR)
#define TEXCOORD1_BIT (1<<TEXCOORD1_ATTR)
#define TEXCOORD2_BIT (1<<TEXCOORD2_ATTR )
#define TEXCOORD3_BIT (1<<TEXCOORD3_ATTR )

#define VERTEXATTR_BIT (1<<VERTEXATTR0_ATTR)
#define VERTEXATTR0_BIT (1<<VERTEXATTR0_ATTR)
#define VERTEXATTR1_BIT (1<<VERTEXATTR1_ATTR)
#define VERTEXATTR2_BIT (1<<VERTEXATTR2_ATTR)
#define VERTEXATTR3_BIT (1<<VERTEXATTR3_ATTR)

#define OBJECTID_BIT (1<<OBJECTID_ATTR)

#define ALL_ATTR_BIT (INDEX_BIT | VERTEX_BIT | COLOR_BIT | NORMAL_BIT | TANGENT_BIT | BINORMAL_BIT | TEXCOORD0_BIT | TEXCOORD1_BIT | TEXCOORD2_BIT | TEXCOORD3_BIT | VERTEXATTR0_BIT | VERTEXATTR1_BIT | VERTEXATTR2_BIT | VERTEXATTR3_BIT | OBJECTID_BIT)


typedef struct
{
    GLuint names[VBO_ATTR_MAX]; // genBuffers
    
    GLenum attr_mode[VBO_ATTR_MAX];     // GL_ARRAY_BUFFER / GL_ELEMENT_ARRAY_BUFFER
    int attr_name[VBO_ATTR_MAX];     // index, vertex, color, normal, tangent, binormal, texcoord[..], vertexattrib[..] 
    GLint attr_size[VBO_ATTR_MAX];      // 1, 2, 3, 4, 16, component number
    GLenum attr_type[VBO_ATTR_MAX];     // ubyte, ushort, uint, float
    int attr_data_n[VBO_ATTR_MAX];   // data[0 .. n-1]
    GLsizei attr_stride[VBO_ATTR_MAX];  // &((type *) data)[1]= &((char *) data)[stride]
    void *attr_data[VBO_ATTR_MAX];      // glXXXPointer()
    
    // attribute remapping, disable, vertex, color, normal, ... 
    int bindings[ATTR_N];    // bindings[ATTRi]= name_id | DISABLE | ENABLE
    GLuint binding_locations[ATTR_N];      // generic vertex attrib / vertex attrib location

    GLenum mode;        // GL_TRIANGLES
    GLenum usage;        // GL_STATIC_DRAW, GL_DYNAMIC_DRAW
    int allocate;
    int n;      // attribute number
} VERTEX_BUFFER;


extern int vertex_buffer_init(void);
extern int vertex_buffer_quit(void);

extern VERTEX_BUFFER *vertex_buffer_create(GLenum mode);
extern VERTEX_BUFFER *vertex_buffer_create_flags(GLenum mode, GLenum usage, int allocate);
extern int vertex_buffer_delete(VERTEX_BUFFER *buffer);

extern int vertex_buffer_check(VERTEX_BUFFER *buffer);
extern int vertex_buffer_draw(VERTEX_BUFFER *buffer);
extern int vertex_buffer_draw_attributes(VERTEX_BUFFER *buffer, unsigned int flags);

extern int vertex_buffer_disable(VERTEX_BUFFER *buffer);

extern int vertex_buffer_add_attribute(VERTEX_BUFFER *buffer, int name, 
    GLint elem_size, GLenum elem_type, int elem_n, GLsizei stride, void *data);
extern int vertex_buffer_add_index(VERTEX_BUFFER *buffer, 
    GLenum elem_type, int elem_n, GLsizei stride, void *data);

extern int vertex_buffer_bind_attribute(VERTEX_BUFFER *buffer, int name, int attr);
extern int vertex_buffer_bind_attribute_location(VERTEX_BUFFER *buffer, int name, GLint location);
extern int vertex_buffer_bind_disable(VERTEX_BUFFER *buffer);

extern int vertex_buffer_rebind_attribute(VERTEX_BUFFER *buffer, int name, int attr);

#endif
