#ifndef _SDLKIT_H
#define _SDLKIT_H

#include <SDL/SDL.h>

extern volatile int stop;
extern const SDL_VideoInfo *screen_info;
extern SDL_Surface *screen;

extern int timer;
extern int timer_rate;

extern int sdlkit_init(int width, int height);
extern int sdlkit_quit(void);
extern int sdlkit_stop(void);
extern int sdlkit_send_stop(void);

extern void sdlkit_get_size(int *w, int *h);

extern void sdlkit_events(void);
extern unsigned char *sdlkit_get_keys(void);
extern int sdlkit_get_key(unsigned char k);

extern void sdlkit_anime(void);
extern void sdlkit_set_rate(int rate);
extern int sdlkit_resize(int width, int height);


#endif
