
#ifndef _VERTEX_BATCH_H
#define _VERTEX_BATCH_H

#include "mat44.h"
#include "vertex_buffer.h"

typedef struct
{
    VERTEX_BUFFER *batch;
    
    MAT44 *model_matrix;
    VERTEX_BUFFER **buffers;
    int size;
    int n;
    
    GLenum mode;
    GLint object_id_location;
    GLint model_matrix_location;
} VERTEX_BATCH;


extern VERTEX_BATCH *vertex_batch_create(GLenum mode, int size);
extern int vertex_batch_delete(VERTEX_BATCH *batch);

extern int vertex_batch_bind_object_id_location(VERTEX_BATCH *batch, GLint location);
extern int vertex_batch_bind_model_matrix_location(VERTEX_BATCH *batch, GLint location);

extern int vertex_batch_begin(VERTEX_BATCH *batch);
extern int vertex_batch_end(VERTEX_BATCH *batch);
extern int vertex_batch_add(VERTEX_BATCH *batch, VERTEX_BUFFER *buffer, MAT44 model_matrix);

extern int vertex_batch_draw(VERTEX_BATCH *batch);
extern int vertex_batch_draw_attributes(VERTEX_BATCH *batch, unsigned int flags);

#endif

