/*
    squelette application sdl
    
    mailto:jciehl@bat710.univ-lyon1.fr
    
    janvier 2007
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <time.h>

#include <SDL/SDL.h>

//
static volatile int stop= 0;
static unsigned char *keys;
static const SDL_VideoInfo *screen_info= NULL;
static SDL_Surface *screen= NULL;
static int width= 0, height= 0;

// timer pour l'animation
static int timer;
static int timer_rate;

void sdlkit_anime(void)
{
#if 0
    static int last= 0;
    
    int time= SDL_GetTicks();
    if((time - last) * timer_rate < 1000)
    {
        SDL_Delay((float) (time - last) / (float) timer_rate);
        last= time;
    }
#else
    SDL_Delay(1000.f / (float) timer_rate);
#endif
    
    timer++;
}

void sdlkit_set_rate(int rate)
{
    timer_rate= rate;
}

int sdlkit_resize(int w, int h)
{
    screen_info= SDL_GetVideoInfo();
    if(screen_info==NULL)
    {
        printf("\n -- failed: '%s'\n", SDL_GetError());
        SDL_Quit();
        return -1;
    }
    
    SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 24);
    SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);

    width= w;
    height= h;
    screen= SDL_SetVideoMode(w, h, 
        screen_info->vfmt->BitsPerPixel, 
        SDL_RESIZABLE | SDL_OPENGL | SDL_HWSURFACE);
    
    if(screen==NULL)
    {
        printf("\n -- failed: '%s'\n", SDL_GetError());
        SDL_Quit();
        return -1;
    }
    
    return 0;
}

void sdlkit_get_viewport(int viewport[4])
{
    viewport[0]= 0;
    viewport[1]= 0;
    viewport[2]= width;
    viewport[3]= height;
}


int sdlkit_init(int w, int h)
{
    if(SDL_Init(SDL_INIT_NOPARACHUTE | SDL_INIT_VIDEO) < 0)
    { 
        printf("\n -- failed : '%s'\n", SDL_GetError());
        return -1;
    }

    keys= SDL_GetKeyState(NULL);
    SDL_WM_SetCaption("SDLkit", "");

    atexit(SDL_Quit);
    sdlkit_resize(w, h);
    
    timer= 0;
    timer_rate= 60;	// frequence d'affichage
    return 0;
}


int sdlkit_quit(void)
{
    SDL_Quit();
    return 0;
}

int sdlkit_stop(void)
{
    return stop;
}

void sdlkit_send_stop(void)
{
    stop= 1;
}

unsigned char *sdlkit_get_keys(void)
{
    return keys;
}

int sdlkit_get_key(unsigned char k)
{
    return (int) keys[k];
}

int sdlkit_get_mouse(int *x, int *y)
{
    return (int) SDL_GetMouseState(x, y);
}


void sdlkit_events(void)
{
    SDL_Event event;

    while(SDL_PollEvent(&event))
    {
        switch(event.type)
        {
            case SDL_VIDEORESIZE:
                sdlkit_resize(event.resize.w, event.resize.h);
                break;
    
            case SDL_QUIT:
                stop= 1;
                break;
        }
    }
}
