#ifndef _GLSL_H
#define _GLSL_H

#include <GL/glew.h>
#include <GL/gl.h>

#ifndef GL_EXT_gpu_shader4
    #warning no support for glsl_program4
    #define NO_PROGRAM4
#endif


extern void extFailed(char *message);
extern void extSupported(char *message);
extern int extIsSupported(char *ext, char *message, int verbose);

extern int glsl_init(void);
extern int glsl_quit(void);

extern GLuint glsl_program_init(char *vfname, char *ffname);
extern int glsl_program_validate(GLuint program);

extern GLuint glsl_program_get_vertex_shader(GLuint program);
extern GLuint glsl_program_get_fragment_shader(GLuint program);

extern int glsl_load_source(char **str, int *n, char *fname);
extern void glsl_program_info(GLuint program);
extern void glsl_shader_info(GLuint shader);
extern void glsl_shader_source_info(GLuint shader, char *fname, const GLchar *source, GLenum type);

extern int glsl_init4(void);
extern GLuint glsl_program4_init(char *vfname, char *gfname, char *ffname);

#ifndef NO_PROGRAM4

extern int glsl_program4_link(GLuint program);
extern GLuint glsl_program4_get_vertex_shader(GLuint program);
extern GLuint glsl_program4_get_geometry_shader(GLuint program);
extern GLuint glsl_program4_get_fragment_shader(GLuint program);

extern int glsl_vertex_shader_get_max_uniforms(void);
extern int glsl_program4_get_free_uniforms(GLuint program);

#endif


#endif

