#if 0

void model_display_init(MODEL *model)
{
	int i;
	
	if(model->draw_index!=NULL)
		return;
	
	model->draw_index= malloc(sizeof(int) * model->attr_n);
	assert(model->draw_index!=NULL);
	
	for(i= 0; i < model->attr_n; i++)
		model->draw_index[i]= model->attr[i][gl_vertex];
	
	model->draw_index_n= model->attr_n;
}	

void model_display(MODEL *model)
{
	glLineWidth(1.f);

	glEnableClientState(GL_VERTEX_ARRAY);
	glVertexPointer(3, GL_FLOAT, sizeof(VERTEX), model->v);
	
	if((model->flags & MODEL_HAS_NORM)!=0)
	{
		glEnableClientState(GL_NORMAL_ARRAY);
		glNormalPointer(GL_FLOAT, sizeof(VERTEXN), model->norm);
	}
	else
		glDisableClientState(GL_NORMAL_ARRAY);
	
	glDrawElements(GL_TRIANGLES, model->draw_index_n, 
		GL_UNSIGNED_INT, model->draw_index);
}

void model_cull_display(MODEL *model)
{
	CULL cull;
	cull_set(&cull);

	if(!(model->flags & MODEL_HAS_AABOX))
		model_set_aabox(model);
	
	// if(cull_vertex(&cull, model->v[0]))
	if(cull_aabox(&cull, model->aabox))
		glColor3f(1.f, 1.f, 1.f);
	else
		glColor3f(1.f, 0.f, 0.f);
	
	glLineWidth(1.f);

	glEnableClientState(GL_VERTEX_ARRAY);
	glVertexPointer(3, GL_FLOAT, sizeof(VERTEX), model->v);
	
	if((model->flags & MODEL_HAS_NORM)!=0)
	{
		glEnableClientState(GL_NORMAL_ARRAY);
		glNormalPointer(GL_FLOAT, sizeof(VERTEXN), model->norm);
	}
	else
		glDisableClientState(GL_NORMAL_ARRAY);
	
	glDrawElements(GL_TRIANGLES, model->draw_index_n, 
		GL_UNSIGNED_INT, model->draw_index);

    {
            VERTEX v;
            int i, p;

            glPointSize(10.f);
            glColor3f(1.f, 1.f, 0.f);
            glBegin(GL_POINTS);

            for(i= 0; i < 8; i++)
            {
                    // genere les sommets de la boite englobante a partir des extremes
                    for(p= 0; p < 3; p++)
                    {
                            if(i & (1<<p))
                                    v[p]= model->aabox[1][p];
                            else
                                    v[p]= model->aabox[0][p];
                    }
                    glVertex3fv(v);
            }
            
            glEnd();
    }
}

#endif
