/*
    squelette application sdl
    
    mailto:jciehl@bat710.univ-lyon1.fr
    
    janvier 2007
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <time.h>

#include <SDL/SDL.h>

//
volatile int stop= 0;
unsigned char *keys;
const SDL_VideoInfo *screen_info= NULL;
SDL_Surface *screen= NULL;

// timer pour l'animation
int timer;
int timer_rate;

void sdlkit_anime(void)
{
    // attente
    SDL_Delay(1000.f / (float) timer_rate);
    
    timer++;
}

void sdlkit_set_rate(int rate)
{
    timer_rate= rate;
}

int sdlkit_resize(int width, int height)
{
    screen_info= SDL_GetVideoInfo();
    if(screen_info==NULL)
    {
        printf("\n -- failed: '%s'\n", SDL_GetError());
        SDL_Quit();
        return -1;
    }
    
    SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 16);
    SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
    
    screen= SDL_SetVideoMode(width, height, 
        screen_info->vfmt->BitsPerPixel, 
        SDL_RESIZABLE | SDL_OPENGL | SDL_HWSURFACE);
    if(screen==NULL)
    {
        printf("\n -- failed: '%s'\n", SDL_GetError());
        SDL_Quit();
        return -1;
    }
    return 0;
}

int sdlkit_init(int width, int height)
{
    if(SDL_Init(SDL_INIT_NOPARACHUTE | SDL_INIT_VIDEO) < 0)
    { 
        printf("\n -- failed : '%s'\n", SDL_GetError());
        return -1;
    }

    keys= SDL_GetKeyState(NULL);
    SDL_WM_SetCaption("SDLkit", "");

    atexit(SDL_Quit);
    sdlkit_resize(width, height);
    
    timer= 0;
    timer_rate= 60;	// frequence d'affichage
    return 0;
}

int sdlkit_quit(void)
{
    SDL_Quit();
    return 0;
}

int sdlkit_stop(void)
{
    return stop;
}

unsigned char *sdlkit_get_keys(void)
{
    return keys;
}

int sdlkit_get_key(unsigned char k)
{
    return (int) keys[k];
}

/*
    sdlkit_get_mouse(int *x, int *y, int state)
*/

void sdlkit_events(void)
{
    SDL_Event event;

    while(SDL_PollEvent(&event))
    {
        switch(event.type)
        {
            case SDL_VIDEORESIZE:
                sdlkit_resize(event.resize.w, event.resize.h);
                break;
            
            case SDL_QUIT:
                stop= 1;
                break;
        }
    }
}
