#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "image.h"

Image imCreer(int w, int h, int channels_n)
{
    Image image;
    
    image.width= w;
    image.height= h;
    image.channels_n= channels_n;
    image.data= (unsigned char *) malloc(w * h * channels_n);
    assert(image.data != NULL);

    memset(image.data, 0, w * h * channels_n);
    return image;
}

/* lire une ligne de l'entete en sautant les lignes de commentaires
 */
static void lireEntete(FILE *f, char *entete)
{
    int code;
    
    do
    {
        code= fscanf(f, "%[^\n] ", entete);
        assert(code > 0);
    }
    while(entete[0]=='#');
}

/* lire l'entete pour recuperer largeur et hauteur 
    et trouver le debut de l'image
 */
static int imLireEntete(FILE *f, char *magic, int *w, int *h)
{
    char entete[1024];
    int code;

    // verifier l'identifiant du format
    lireEntete(f, entete);
    if(strcmp(entete, magic)!=0)
        return -1;

    // recuperer les dimensions de l'image
    lireEntete(f, entete);
    code= sscanf(entete, " %d %d ", w, h);
    if(code != 2)
        return -1;
    
    // passer la ligne contenant 255 pour trouver le premier pixel
    lireEntete(f, entete);
    return 0;
}

Image imCreerLecturePPM(char *fichier)
{
    Image image;
    FILE *f;
    unsigned char *pix;
    int largeur, hauteur;
    int x, y;
    int code;
    
    f= fopen(fichier, "r");
    assert(f != NULL);

    code= imLireEntete(f, "P6", &largeur, &hauteur);
    assert(code == 0);
    
    image= imCreer(largeur, hauteur, 3);
    for(y= 0; y < hauteur; y++)
    {
        for(x= 0; x < largeur; x++)
        {
            pix= imGetPtr(&image, x, y);
            code= fscanf(f, "%c%c%c", &pix[0], &pix[1], &pix[2]);
            assert(code==3);
        }
    }
    
    return image;
}

Image imCreerLecturePGM(char *fichier)
{
    Image image;
    FILE *f;
    unsigned char *pix;
    int largeur, hauteur;
    int x, y, g;
    int code;
    
    f= fopen(fichier, "r");
    assert(f != NULL);

    code= imLireEntete(f, "P2", &largeur, &hauteur);
    assert(code == 0);
        
    image= imCreer(largeur, hauteur, 1);
    for(y= 0; y < hauteur; y++)
    {
        for(x= 0; x < largeur; x++)
        {
            code= fscanf(f, " %d ", &g);
            assert(code==1);
            pix= imGetPtr(&image, x, y);
            pix[0]= (unsigned char) (g & 0xff);
        }
    }
    
    return image;
}


void imEcriturePPM(Image *image, char *fichier)
{
    FILE *f;
    unsigned char *pix;
    int x, y;
     
    f= fopen(fichier, "w");
    assert(f != NULL);
    
    fprintf(f, "P6\n%d %d\n255\n", image->width, image->height);

    for(y= 0; y < image->height; y++)
    {
        for(x= 0; x < image->width; x++)
        {
            pix= imGetPtr(image, x, y); 
            if(image->channels_n==3)
                fprintf(f, "%c%c%c", pix[2], pix[1], pix[0]);
            else
                fprintf(f, "%c%c%c", pix[0], pix[0], pix[0]);
        }
    }
    
    fclose(f);
}

unsigned char *imGetPtr(Image *image, int x, int y)
{
    assert(image != NULL);
    assert(x>=0 && x < image->width);
    assert(y>=0 && y < image->height);
    
    return &image->data[(y*image->width + x) * image->channels_n];
}

