/*
	nettoyage du modele
	
	mailto:jciehl@bat710.univ-lyon1.fr
	fevrier 2006
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "model.h"
#include "model_clean.h"
#include "vec.h"


/*	nettoyage des structures non utilisees du modele
	construit un modele lineaire pour l'affichage avec vertex_buffer_objects

	. enumerer tous les attributs sur le meme indice
	. placer les normales des faces apres les normales des sommets
	
	. verifier le nombre d'attributs par sommet :
		inserer des attributs vides s'ils ne sont pas definis pour tous les sommets
		ne pas creer d'attributs inutiles (le modele n'utilise ni textures, ni normales)
*/
int model_vbo_clean(MODEL **pmodel)
{
	MODEL *model;
	MODEL *clean;
	FACE *face;
	ATTR *attr;
	int *mat;
	int i, j;
	int v, f;
	
	model= *pmodel;
	if(model==NULL)
		return -1;

	printf("model '%s' : vbo clean ...\n", model->filename);

	if((model->flags & MODEL_IS_TRIANGLES)==0)
		model_set_triangles(&model);
	
	model_set_vertex_norm(model);
	clean= model_new(model->filename);

	attr= (ATTR *) malloc(sizeof(ATTR) * model->v_n);
	assert(attr!=NULL);
	for(i= 0; i < model->v_n; i++)
	{
		attr[i][gl_vertex]= -1;
		attr[i][gl_tex]= -1;
		attr[i][gl_norm]= -1;
	}

	mat= (int *) malloc(sizeof(int) * model->mat_n);
	assert(mat!=NULL);
	for(i= 0; i < model->mat_n; i++)
		mat[i]= -1;

	/* passe 1
	 */
	for(i= 0; i < model->faces_n; i++)
	{
		face= &model->faces[i];
		
		f= model_add_face(clean, -1, face->mat);
		// les normales des faces seront inserees en passe 2

		if(mat[model->faces[i].mat]==-1)
		{
			mat[model->faces[i].mat]= clean->mat_n;

			array_add((void **) &clean->mat, &clean->mat_size, 
				clean->mat_n,
				sizeof(MATERIAL), MODEL_MATERIAL_MORE);
			mat_copy(&clean->mat[clean->mat_n], &model->mat[model->faces[i].mat]);
			clean->mat_n++;
		}

		clean->faces[f].mat= mat[model->faces[i].mat];

		for(j= 0; j < face->n; j++)
		{
			v= model->attr[face->attr + j][gl_vertex];
			if(attr[v][gl_vertex]==-1
			|| attr[v][gl_tex] != model->attr[face->attr + j][gl_tex]
			|| attr[v][gl_norm] != model->attr[face->attr + j][gl_norm])
			{
				attr[v][gl_vertex]= clean->v_n;
				attr[v][gl_tex]= model->attr[face->attr + j][gl_tex];
				attr[v][gl_norm]= model->attr[face->attr + j][gl_norm];
				
				//
				array_add((void **) &clean->v, &clean->v_size, 
					clean->v_n,
					sizeof(VERTEX), MODEL_VERTEX_MORE);
				vertex_copy(&clean->v[clean->v_n], &model->v[v]);
				
				if(attr[v][gl_tex] >= 0)
				{
					array_add((void **) &clean->tex, &clean->tex_size, 
						clean->v_n,
						sizeof(VERTEXT), MODEL_VERTEX_MORE);
					tex_copy(&clean->tex[clean->v_n], &model->tex[attr[v][gl_tex]]);
					clean->tex_n++;
				}
				
				if(attr[v][gl_norm] >= 0)
				{
					array_add((void **) &clean->norm, &clean->norm_size, 
						clean->v_n,
						sizeof(VERTEXN), MODEL_VERTEX_MORE);
					norm_copy(&clean->norm[clean->v_n], &model->norm[attr[v][gl_norm]]);
					clean->norm_n++;
				}
				
				clean->v_n++;
			}
			
			// 
			array_add((void **) &clean->attr, &clean->attr_size, 
				clean->attr_n,
				sizeof(ATTR), MODEL_FACE_MORE);

			clean->attr[clean->attr_n][gl_vertex]= attr[v][gl_vertex];

			if(attr[v][gl_tex] >= 0)
				clean->attr[clean->attr_n][gl_tex]= attr[v][gl_vertex];
			else
				clean->attr[clean->attr_n][gl_tex]= -1;

			if(attr[v][gl_norm] >= 0)
				clean->attr[clean->attr_n][gl_norm]= attr[v][gl_vertex];
			else
				clean->attr[clean->attr_n][gl_norm]= -1;

			clean->attr_n++;
		}
		
		clean->faces[f].n= face->n;
	}

	free(attr);
	free(mat);

	//
	clean->flags|= MODEL_IS_VBO_CLEAN;
	clean->flags|= MODEL_IS_CLEAN;
	clean->flags|= MODEL_IS_TRIANGLES;
	if(clean->tex_n > 0)
		clean->flags|= MODEL_HAS_TEX;
	if(clean->norm_n > 0)
		clean->flags|= MODEL_HAS_NORM;

#if 0	
	printf("  face array %d, clean %d\n", model->faces_n, clean->faces_n);
	printf("  mat array %d, clean %d\n", model->mat_n, clean->mat_n);
	printf("  attr array %d, clean %d\n", model->attr_n, clean->attr_n);
	printf("  vertex array %d, clean %d\n", model->v_n, clean->v_n);
	printf("  tex array %d, clean %d\n", model->tex_n, clean->tex_n);
	printf("  norm array %d, clean %d\n", model->norm_n, clean->norm_n);
#endif
	
	model_free(model);
	*pmodel= clean;
	
	return 0;
}


int model_is_vbo_clean(MODEL *model)
{
	FACE *face;
	int v;
	int i, j;
	
	if(model==NULL)
		return -1;

	if((model->flags & MODEL_IS_VBO_CLEAN)!=0)
		return 1;

	if((model->flags & MODEL_IS_TRIANGLES)==0)
		goto not_triangles;

	if((model->flags & MODEL_HAS_NORM)==0)
		goto not_vbo_clean;
	
	for(i= 0; i < model->faces_n; i++)
	{
		face= &model->faces[i];
		for(j= 0; j < face->n; j++)
		{
			v= model->attr[face->attr + j][gl_vertex];
			if(model->attr[face->attr + j][gl_tex]!=-1 
			&& model->attr[face->attr + j][gl_tex]!=v)
				goto not_vbo_clean;
		#if 0
			if(model->attr[face->attr + j][gl_norm]!=-1 
			&& model->attr[face->attr + j][gl_norm]!=v)
				goto not_vbo_clean;
		#else
			if(model->attr[face->attr + j][gl_norm]!=v)
				goto not_vbo_clean;
		#endif
		}
	}
	
vbo_clean:
	model->flags|= MODEL_IS_VBO_CLEAN;
	model->flags|= MODEL_IS_CLEAN;
	model->flags|= MODEL_IS_TRIANGLES;
	if(model->tex_n > 0)
		model->flags|= MODEL_HAS_TEX;
	if(model->norm_n > 0)
		model->flags|= MODEL_HAS_NORM;
	return 1;

not_triangles:
	model->flags&= ~MODEL_IS_TRIANGLES;

not_vbo_clean:
	model->flags&= ~MODEL_IS_VBO_CLEAN;
	return 0;
}

/* elimine les structures non utilisees
 */
int model_clean(MODEL **pmodel)
{
	MODEL *model;
	MODEL *clean;
	FACE *face;
	FACE *cface;
	int *vertex, *tex, *norm, *mat;
	int a0;
	int i, j;

	model= *pmodel;
	if(model==NULL)
		return -1;

	printf("model '%s' : clean ...\n", model->filename);
	model_set_vertex_norm(model);
	clean= model_new(model->filename);
		
	vertex= (int *) malloc(sizeof(int) * model->v_n);
	assert(vertex!=NULL);
	for(i= 0; i < model->v_n; i++)
		vertex[i]= -1;
	
	tex= (int *) malloc(sizeof(int) * model->tex_n);
	assert(tex!=NULL);
	for(i= 0; i < model->tex_n; i++)
		tex[i]= -1;
	
	norm= (int *) malloc(sizeof(int) * model->norm_n);
	assert(norm!=NULL);
	for(i= 0; i < model->norm_n; i++)
		norm[i]= -1;

	mat= (int *) malloc(sizeof(int) * model->mat_n);
	assert(mat!=NULL);
	for(i= 0; i < model->mat_n; i++)
		mat[i]= -1;
	
	//
	for(i= 0; i < model->faces_n; i++)
	{
		face= &model->faces[i];
		
		array_add((void **) &clean->faces, &clean->faces_size,
			clean->faces_n,
			sizeof(FACE), MODEL_FACE_MORE);
		
		cface= &clean->faces[clean->faces_n];
		cface->attr= clean->attr_n;
		cface->norm= -1;

		if(mat[face->mat]==-1)
		{
			mat[face->mat]= clean->mat_n;

			array_add((void **) &clean->mat, &clean->mat_size, 
				clean->mat_n,
				sizeof(MATERIAL), MODEL_MATERIAL_MORE);
			mat_copy(&clean->mat[clean->mat_n], &model->mat[face->mat]);
			clean->mat_n++;
		}

		cface->mat= mat[face->mat];
		
		for(j= 0; j < face->n; j++)
		{
			a0= face->attr + j;
			
			if(vertex[model->attr[a0][gl_vertex]]==-1)
			{
				vertex[model->attr[a0][gl_vertex]]= clean->v_n;
				
				array_add((void **) &clean->v, &clean->v_size,
					clean->v_n,
					sizeof(VERTEX), MODEL_VERTEX_MORE);
				vertex_copy(&clean->v[clean->v_n], &model->v[model->attr[a0][gl_vertex]]);
				clean->v_n++;
			}
			
			if(model->attr[a0][gl_tex] >= 0 
			&& tex[model->attr[a0][gl_tex]]==-1)
			{
				tex[model->attr[a0][gl_tex]]= clean->tex_n;
				
				array_add((void **) &clean->tex, &clean->tex_size,
					clean->tex_n, 
					sizeof(VERTEXT), MODEL_VERTEX_MORE);
				tex_copy(&clean->tex[clean->tex_n], &model->tex[model->attr[a0][gl_tex]]);
				clean->tex_n++;
			}
			
			if(model->attr[a0][gl_norm] >= 0
			&& norm[model->attr[a0][gl_norm]]==-1)
			{
				norm[model->attr[a0][gl_norm]]= clean->norm_n;
				
				array_add((void **) &clean->norm, &clean->norm_size,
					clean->norm_n,
					sizeof(VERTEXN), MODEL_VERTEX_MORE);
				norm_copy(&clean->norm[clean->norm_n], &model->norm[model->attr[a0][gl_norm]]);
				clean->norm_n++;
			}
			
			//
			array_add((void **) &clean->attr, &clean->attr_size,
				clean->attr_n,
				sizeof(ATTR), MODEL_ATTR_MORE);
			clean->attr[clean->attr_n][gl_vertex]= vertex[model->attr[a0][gl_vertex]];
			if(model->attr[a0][gl_tex] >= 0)
				clean->attr[clean->attr_n][gl_tex]= tex[model->attr[a0][gl_tex]];
			else
				clean->attr[clean->attr_n][gl_tex]= -1;
			if(model->attr[a0][gl_norm] >= 0)
				clean->attr[clean->attr_n][gl_norm]= norm[model->attr[a0][gl_norm]];
			else
				clean->attr[clean->attr_n][gl_norm]= -1;
			
			clean->attr_n++;
		}
		
		cface->n= face->n;
		clean->faces_n++;
	}

	free(vertex);
	free(tex);
	free(norm);
	free(mat);
	
	//
	clean->flags|= MODEL_IS_CLEAN;
	if(clean->tex_n==clean->v_n)
		clean->flags|= MODEL_HAS_TEX;
	if(clean->norm_n >= clean->v_n)
		clean->flags|= MODEL_HAS_NORM;

#if 0
	printf("  face array %d, clean %d\n", model->faces_n, clean->faces_n);
	printf("  mat array %d, clean %d\n", model->mat_n, clean->mat_n);
	printf("  attr array %d, clean %d\n", model->attr_n, clean->attr_n);
	printf("  vertex array %d, clean %d\n", model->v_n, clean->v_n);
	printf("  tex array %d, clean %d\n", model->tex_n, clean->tex_n);
	printf("  norm array %d, clean %d\n", model->norm_n, clean->norm_n);
#endif
	
	model_free(model);
	*pmodel= clean;
	return 0;
}
