/*
	visu modeles
	
	mailto:jciehl@bat710.univ-lyon1.fr
	
	fevrier 2004
	fevrier 2006
*/

#ifdef _WIN32
#include <windows.h>
#else
#include <unistd.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

#include <GL/glut.h>

#include "model.h"
#include "model_clean.h"
#include "maya_obj.h"
#include "off.h"
#include "vec.h"
#include "glut_view.h"


int main(int argc, char **argv)
{
	char *clean_fname= NULL;
	char *fname= NULL;
	MODEL *model;
	int clean, vbo;
	
	srand(time(NULL));

	glutInit(&argc, argv);

	if(argc < 2 || argc > 4)
	{
		printf("usage: %s [--vbo output.obj] filename.obj\n", argv[0]);
		printf("usage: %s [--save output.obj] filename.obj\n", argv[0]);
		return 0;
	}

	//
	clean= 0;
	vbo= 0;
	if(argc==2)
		fname= argv[1];
	
	else if(argc > 2) 
	{
		if(strcmp(argv[1], "--save")==0)
			clean= 1;
		else if(strcmp(argv[1], "--vbo")==0)
			vbo= 1;
		else
		{
			printf("usage: %s [--vbo output.obj] filename.obj\n", argv[0]);
			printf("usage: %s [--save output.obj] filename.obj\n", argv[0]);
			return 1;
		}
		
		if(argc==3)
			fname= argv[2];
		else
		{
			clean_fname= argv[2];
			fname= argv[3];
		}
	}

	if(fname==NULL)
	{
		printf("usage: %s [--vbo output.obj] filename.obj\n", argv[0]);
		printf("usage: %s [--save output.obj] filename.obj\n", argv[0]);
		return 1;
	}
	
	model= NULL;
	if((model_is_obj(fname)==0 && model_load_obj(&model, fname) < 0)
	|| (model_is_off(fname)==0 && model_load_off(&model, fname) < 0))
	{
		printf("\n  -- unable to load model '%s'\n", fname);
		return 1;
	}
	
	if(clean!=0)
	{
		printf("model '%s' : forced clean\n", fname);
		model_clean(&model);
	}
	if(vbo!=0)
	{
		printf("model '%s' : forced vbo clean\n", fname);
		model_vbo_clean(&model);
	}
	
	if(clean_fname!=NULL)
	{
		if(model_save_obj(model, clean_fname) < 0)
		{
			printf("\n  -- unable to save model '%s'\n", clean_fname);
			return 1;
		}

		printf("\nsave model '%s'\n", clean_fname);
	}

	if(model_is_vbo_clean(model)==0)
	{
		printf("model '%s' : forced vbo clean\n", fname);
		model_vbo_clean(&model);
	}

	model_set_aabox(model);
	model_display_init(model);
	
	glut_view((void *) model_cull_display, (void *) model);
	
	model_free(model);

	return 0;
}
