#ifndef _GLMAT_H
#define _GLMAT_H

#include <GL/gl.h>

typedef GLfloat GLMAT[16];
typedef GLfloat GLVEC[4];

extern void glmat_identity(GLfloat m[16]);
extern int glmat_invert(const GLfloat src[16], GLfloat inverse[16]);
extern void glmat_mul(const GLfloat a[16], const GLfloat b[16], GLfloat result[16]);

extern void glmat_mul_vec(const GLfloat matrix[16], const GLfloat v[4], GLfloat result[4]);
extern void glvec_normalize(GLfloat v[3]);
extern void glvec_cross(GLfloat v1[3], GLfloat v2[3], GLfloat result[3]);

extern void glvec_print(GLVEC v, char *m);
extern void glmat_print(GLMAT a, char *m);


#endif
