function [LC]=get_CLS_Score(Base_sup,Base_Nonsup)
t = 10;
Comments = false;
 
 %%%%%%% les paramtres %%%%%%%%%%
 k=10; %%%%%%% Le paramtre de voisinage %%%%
  
 Nb_Labs=size(Base_sup,1);
 PL=size(Base_sup,2);
 size(Base_Nonsup,1);
 size(Base_Nonsup,2);
 ligne_label=Base_sup(:,PL);
 Base_sup=Base_sup(:,[1:PL-1]);
 
 %%%%%%%%% faire un K-Means de Base_Nonsup %%%%%%

 N=size(Base_Nonsup,1);
 if (N>900)
  KM=5*sqrt(N);
  KM=round(KM);
  dim=sqrt(KM);
  dim=round(dim);
  sM=som_make(Base_Nonsup,'batch','msize',[dim dim],'init','randinit');
  Nouvelle_Base=union(Base_sup,sM.codebook,'rows');
 else
  %Nouvelle_Base=union(Base_sup,Base_Nonsup,'rows');
  Nouvelle_Base=[Base_sup;Base_Nonsup];
 end
 
 N=size(Nouvelle_Base,1);
 P=size(Nouvelle_Base,2);
 %%%%%%%%% calcul de la matrice de dissimilarit %%%%%
 %Nouvelle_Base = som_normalize(Nouvelle_Base,'var');
 Diss=dist(Nouvelle_Base')/10000;
 
 
 Mat_cont=zeros(N,N); %%%%%% Contient les contraintes CL uniquement
  
 %%%%%%% calcul du graphe de voisinage %%%%%%%%%

 Neigh=zeros(N,k+(Nb_Labs*(Nb_Labs-1)/2),2);
 Neigh=Neigh-1;
 
 for ind=1:N    % pour eliminer le diametre 
   Diss(ind,ind)=10000;
 end
 for (j=1:k)
   [ID,I] = min(Diss);
   Neigh(:,j,1)=I;
   Neigh(:,j,2)=ID;
   for ind=1:N
     Diss(I(ind),ind)=10000;
   end
 end
 
 if(size(Diss,1)<Nb_Labs)
     Nb_Labs=size(Diss,1);
 end
     
 
 for(i=1:Nb_Labs)
   for(j=1:Nb_Labs)
       if (i~=j)
            if (ligne_label(i)~=ligne_label(j))
                Mat_cont(i,j)=-1;
             else
                mv=1;
                while ((Neigh(i,mv,1)~=j) && (Neigh(i,mv,1)~=-1))
                   mv=mv+1;
                end
                if (Neigh(i,mv,1)==-1)
                  Neigh(i,mv,1)=j;
                  Neigh(i,mv,2)=Diss(i,j);
                end
             end
        end
   end
 end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
D=zeros(1,N);
S=zeros(N,N);
kk=size(Neigh,2);
for(i=1:N)
     ind=1;
     while((ind<=kk)&&(Neigh(i,ind,1)~=-1))
        j=Neigh(i,ind,1);
        Diss_ij=Neigh(i,ind,2);
        S(i,j)=exp(-Diss_ij*Diss_ij/t);
        D(1,i)=D(1,i)+S(i,j);
        ind=ind+1;
     end
 end
%%%% pour la variable r %%%%%%%
 
 
for (r=1:P)
    if Comments
      CLS_variable=r
    end
 %%%%%%%%%%%%%% Terme 1 %%%%%%%%%%%%%%%
 Terme1=0;
 for(i=1:N-1)
   for(j=i+1:N)
     if (S(i,j)~=0)
       ecart=(Nouvelle_Base(i,r)-Nouvelle_Base(j,r))*(Nouvelle_Base(i,r)-Nouvelle_Base(j,r));
       Terme1=Terme1+ecart*S(i,j);
     end
   end
 end
  
 %%%%%%%%%%%% Terme 2 %%%%%%%%%%%%%%%%%%
 Terme2=0;
 Mns=mean(Nouvelle_Base(:,r));
 for(i=1:N-1)
     for(j=i+1:N)
         if(Mat_cont(i,j)==-1)
             f=Nouvelle_Base(j,r);
         else
             f=Mns;        
         end
         ecart=(Nouvelle_Base(i,r)-f)*(Nouvelle_Base(i,r)-f);
         Terme2=Terme2+ecart*D(1,i);
     end
 end
 
 LC(r)=Terme1/Terme2;
end
end